/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.BDToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.havi.ui.HActionable;
import org.havi.ui.HComponentOrdering;
import org.havi.ui.HEventMulticaster;
import org.havi.ui.HGraphicsConfiguration;
import org.havi.ui.HSceneFactory;
import org.havi.ui.HSceneTemplate;
import org.havi.ui.HScreen;
import org.havi.ui.HScreenDimension;
import org.havi.ui.HScreenPoint;
import org.havi.ui.HScreenRectangle;
import org.havi.ui.event.HEventGroup;
import org.videolan.BDJXletContext;
import org.videolan.GUIManager;
import org.videolan.Logger;

public class HScene
extends Container
implements HComponentOrdering {
    public static final int IMAGE_NONE = 0;
    public static final int IMAGE_STRETCH = 1;
    public static final int IMAGE_CENTER = 2;
    public static final int IMAGE_TILE = 3;
    public static final int NO_BACKGROUND_FILL = 0;
    public static final int BACKGROUND_FILL = 1;
    private boolean active = false;
    private int backgroundMode = 0;
    private Image image = null;
    private int imageMode = 0;
    private WindowListener windowListener = null;
    private HEventGroup eventGroup = null;
    private Map shortcuts = Collections.synchronizedMap(new HashMap());
    private boolean shortcutsEnabled = true;
    private BDJXletContext context = BDJXletContext.getCurrentContext();
    private static final Logger logger = Logger.getLogger(HScene.class.getName());
    private static final long serialVersionUID = 422730746877212409L;

    protected HScene() {
        if (this.context == null) {
            logger.error("HScene() created from privileged context: " + Logger.dumpStack());
        }
        BDToolkit.addComponent((Component)this);
    }

    public BDJXletContext getXletContext() {
        return this.context;
    }

    @Override
    public void paint(Graphics g) {
        if (this.backgroundMode == 1) {
            g.setColor(this.getBackground());
            g.fillRect(super.getX(), super.getY(), super.getWidth(), super.getHeight());
        }
        if (this.image != null) {
            switch (this.imageMode) {
                case 2: {
                    g.drawImage(this.image, (super.getWidth() - this.image.getWidth(null)) / 2, (super.getHeight() - this.image.getHeight(null)) / 2, null);
                    break;
                }
                case 1: {
                    g.drawImage(this.image, super.getX(), super.getY(), super.getWidth(), super.getHeight(), null);
                    break;
                }
                case 3: {
                    for (int x = super.getX(); x < super.getWidth(); x += this.image.getWidth(null)) {
                        for (int y = super.getY(); y < super.getHeight(); y += this.image.getHeight(null)) {
                            g.drawImage(this.image, x, y, null);
                        }
                    }
                    break;
                }
            }
        }
        super.paint(g);
    }

    @Override
    public boolean isDoubleBuffered() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public int getComponentZOrder(Component component) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != component) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setComponentZOrder(Component component, int index) {
        if (index < 0) {
            return;
        }
        int i = this.getComponentZOrder(component);
        if (i < 0) {
            return;
        }
        if (i == index) {
            return;
        }
        this.remove(component);
        if (i > index) {
            this.add(component, index);
        } else {
            this.add(component, index - 1);
        }
    }

    @Override
    public Component addBefore(Component component, Component behind) {
        int index = this.getComponentZOrder(behind);
        if (index < 0) {
            return null;
        }
        return super.add(component, index);
    }

    @Override
    public Component addAfter(Component component, Component front) {
        int index = this.getComponentZOrder(front);
        if (index < 0) {
            return null;
        }
        return super.add(component, index + 1);
    }

    @Override
    public boolean popToFront(Component component) {
        if (this.getComponentZOrder(component) < 0) {
            return false;
        }
        this.setComponentZOrder(component, 0);
        return true;
    }

    @Override
    public boolean pushToBack(Component component) {
        if (this.getComponentZOrder(component) < 0) {
            return false;
        }
        this.setComponentZOrder(component, this.getComponentCount());
        return true;
    }

    @Override
    public boolean pop(Component component) {
        int index = this.getComponentZOrder(component);
        if (index < 0) {
            return false;
        }
        if (index == 0) {
            return true;
        }
        this.setComponentZOrder(component, index - 1);
        return true;
    }

    @Override
    public boolean push(Component component) {
        int index = this.getComponentZOrder(component);
        if (index < 0) {
            return false;
        }
        if (index == this.getComponentCount()) {
            return true;
        }
        this.setComponentZOrder(component, index + 1);
        return true;
    }

    @Override
    public boolean popInFrontOf(Component move, Component behind) {
        int index = this.getComponentZOrder(behind);
        if (index < 0 || this.getComponentZOrder(move) < 0) {
            return false;
        }
        this.setComponentZOrder(move, this.getComponentZOrder(behind));
        return true;
    }

    @Override
    public boolean pushBehind(Component move, Component front) {
        int index = this.getComponentZOrder(front);
        if (index < 0 || this.getComponentZOrder(move) < 0) {
            return false;
        }
        this.setComponentZOrder(move, index + 1);
        return true;
    }

    public void addWindowListener(WindowListener listener) {
        this.windowListener = HEventMulticaster.add(this.windowListener, listener);
    }

    public void removeWindowListener(WindowListener listener) {
        this.windowListener = HEventMulticaster.remove(this.windowListener, listener);
    }

    protected void processWindowEvent(WindowEvent event) {
        if (this.windowListener != null) {
            switch (event.getID()) {
                case 200: {
                    this.windowListener.windowOpened(event);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(event);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(event);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(event);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(event);
                    break;
                }
                case 205: {
                    this.windowListener.windowActivated(event);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(event);
                }
            }
        }
        switch (event.getID()) {
            case 205: {
                this.active = true;
                break;
            }
            case 206: {
                this.active = false;
            }
        }
    }

    public Component getFocusOwner() {
        if (!this.active) {
            return null;
        }
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].hasFocus()) continue;
            return comps[i];
        }
        return null;
    }

    public synchronized void dispose() {
        HSceneFactory sf = HSceneFactory.getInstance();
        if (sf != null) {
            sf.dispose(this);
        }
    }

    protected void disposeImpl() {
        try {
            this.removeAll();
            Graphics g = GUIManager.getInstance().getGraphics();
            if (g != null) {
                Rectangle r = this.getBounds();
                g.clearRect(r.x, r.y, r.width, r.height);
                g.dispose();
            }
            if (this.image != null) {
                this.image.flush();
            }
            if (this.shortcuts != null) {
                this.shortcuts.clear();
            }
        }
        finally {
            this.image = null;
            this.eventGroup = null;
            this.shortcuts = null;
            this.windowListener = null;
            this.context = null;
        }
    }

    public boolean addShortcut(int keyCode, HActionable act) {
        boolean hasComp = false;
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != act) continue;
            hasComp = true;
            break;
        }
        if (!hasComp) {
            return false;
        }
        this.shortcuts.put(keyCode, act);
        return true;
    }

    public void removeShortcut(int keyCode) {
        this.shortcuts.remove(keyCode);
    }

    public HActionable getShortcutComponent(int keyCode) {
        return (HActionable)this.shortcuts.get(keyCode);
    }

    public void enableShortcuts(boolean enable) {
        this.shortcutsEnabled = enable;
    }

    public boolean isEnableShortcuts() {
        return this.shortcutsEnabled;
    }

    public int getShortcutKeycode(HActionable comp) {
        Integer key;
        Iterator iterator = this.shortcuts.keySet().iterator();
        while ((key = (Integer)iterator.next()) != null) {
            HActionable action = (HActionable)this.shortcuts.get(key);
            if (action != comp) continue;
            return key;
        }
        return 0;
    }

    public int[] getAllShortcutKeycodes() {
        Object[] src = this.shortcuts.keySet().toArray();
        int[] dest = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            dest[i] = (Integer)src[i];
        }
        return dest;
    }

    public HScreenRectangle getPixelCoordinatesHScreenRectangle(Rectangle rect) {
        Dimension size = GUIManager.getInstance().getSize();
        return new HScreenRectangle((float)rect.x / (float)size.width, (float)rect.y / (float)size.height, (float)rect.width / (float)size.width, (float)rect.height / (float)size.height);
    }

    public HSceneTemplate getSceneTemplate() {
        HSceneTemplate template = new HSceneTemplate();
        HGraphicsConfiguration config = HScreen.getDefaultHScreen().getDefaultHGraphicsDevice().getCurrentConfiguration();
        Rectangle sceneRect = super.getBounds();
        HScreenRectangle screenRect = this.getPixelCoordinatesHScreenRectangle(sceneRect);
        template.setPreference(0, config, 2);
        template.setPreference(1, sceneRect.getSize(), 2);
        template.setPreference(2, sceneRect.getLocation(), 2);
        template.setPreference(4, new HScreenDimension(screenRect.width, screenRect.height), 2);
        template.setPreference(8, new HScreenPoint(screenRect.x, screenRect.y), 2);
        return template;
    }

    public void setActive(boolean focus) {
        if (this.active && !focus) {
            this.dispatchEvent(new WindowEvent((Window)((Object)GUIManager.getInstance()), 206));
        }
        this.active = focus;
    }

    public void setKeyEvents(HEventGroup eventGroup) {
        this.eventGroup = eventGroup;
    }

    public HEventGroup getKeyEvents() {
        return this.eventGroup;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        if (visible) {
            GUIManager.getInstance().setVisible(visible);
        }
    }

    public int getBackgroundMode() {
        return this.backgroundMode;
    }

    public void setBackgroundMode(int mode) {
        this.backgroundMode = mode;
    }

    public void setBackgroundImage(Image image) {
        this.image = image;
    }

    public Image getBackgroundImage() {
        return this.image;
    }

    public boolean setRenderMode(int mode) {
        this.imageMode = mode;
        return true;
    }

    public int getRenderMode() {
        return this.imageMode;
    }
}

